package coreservlets.listeners;

import javax.servlet.*;
import javax.servlet.http.*;

/** Proces nasuchujcy, ktry ledzi zamwienia na jachty.
 *  W tym celu proces monitoruje wartoci atrybutw sesji
 *  o nazwach orderedItem oraz purchasedItem.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class YachtWatcher
    implements HttpSessionAttributeListener {
  private String orderAttributeName = "orderedItem";
  private String purchaseAttributeName = "purchasedItem";
  private String itemName = "jacht";

  /** Sprawdzenie pocztkowego zamwienia i ostateczbnego nabycia
   *  jachtu. Jeeli atrybut orderedItem ma warto "jacht",
   *  nastpuje zapisanie informacji o treci "Klient zoy zamwienie na jacht".
   *  Jeeli atrybut purchasedItem ma warto "jacht", nastpuje 
   *  zapisanie informacji o treci "Klient ostatecznie zakupi jacht".
   */
  public void attributeAdded(HttpSessionBindingEvent event) {
    checkAttribute(event, orderAttributeName, itemName,
                   " zoy zamwienie na ");
    checkAttribute(event, purchaseAttributeName, itemName,
                   " sfinalizowa zakup ");
  }

  /** Sprawdza, czy zamwienie zostao anulowane: czy zamwienie na "jacht"
   *  zostao wycofane? Zapisuje informacj o treci "Klient anulowa zamwienie
   *  na jacht", jeli atrybut orderedItem ma warto "jacht".
   */
  public void attributeRemoved(HttpSessionBindingEvent event) {
    checkAttribute(event, orderAttributeName, itemName,
                   " anulowa zamwienie na ");
  }

  /** Sprawdza, czy towar zosta zastpiony: czy "jacht" zosta
   *  zastpiony przez jaki inny towar? Zapisuje informacj o treci
   *  "Klient wybra nowy towar, ktry zastpi jacht",
   *  jeli atrybut orderedItem ma warto "jacht".
   */
  public void attributeReplaced(HttpSessionBindingEvent event) {
    checkAttribute(event, orderAttributeName, itemName,
                   " wybra nowy towar, ktry zastpi ");
  }

  private void checkAttribute(HttpSessionBindingEvent event,
                              String orderAttributeName,
                              String keyItemName,
                              String message) {
    String currentAttributeName = event.getName();
    String currentItemName = (String)event.getValue();
    if (currentAttributeName.equals(orderAttributeName) &&
        currentItemName.equals(keyItemName)) {
      ServletContext context =
        event.getSession().getServletContext();
      context.log("Klient" + message + keyItemName + ".");
    }
  }
}
